import { StyleSheet } from "react-native";
import dpr from "../Utilities/CustomStyleAttribute/dpr";

const allCategoriesStyle = StyleSheet.create({
    wrapper: {
        flex: 1,
        backgroundColor: "#FFF",
        position: "relative",
    },
    superCont: {},
    container: {
        backgroundColor: "#fff",
        paddingTop: dpr(20),
        marginBottom: dpr(120),
    },
    singleCtgContainer: {
        paddingHorizontal: dpr(20),
        paddingBottom: dpr(20),
    },
    searchContainer: {
        borderBottomWidth: 1,
        width: dpr(250, "w"),
        paddingTop: 0,
        borderColor: "#898989",
        position: "absolute",
        right: dpr(20),
        top: dpr(17),
    },
    item: {
        flex: 1,
        flexDirection: "row",
        backgroundColor: "white",
        alignItems: "center",
        borderRadius: 7,
    },
    imageContainer: {
        height: dpr(90),
        width: dpr(90),
        borderWidth: 1,
        borderColor: "#DFDFDF",
        borderRadius: 6,
        flexDirection: "row",
        justifyContent: "center",
        alignItems: "center",
    },
    borderWidth0: {borderWidth: 0},
    image: {
        height: dpr(50),
        width: dpr(50),
    },
    categoryView: {
        marginLeft: dpr(17),
    },
    categoryName: {
        fontSize: dpr(17),
        fontFamily: "DMSans_500Medium",
        color: "#2C2C2C",
    },
    subCategories: (length) => ({
        fontSize: dpr(15),
        color: length == 0 ? "#DFDFDF" : "#898989",
        fontFamily: "Roboto_500Medium",
        marginRight: dpr(10),
    }),
    subCategoryContainer: {
        flexDirection: "row",
        alignItems: "center",
        marginTop: dpr(8),
    },
    singleSubText: {
        marginLeft: dpr(15),
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(15),
        color: "#2C2C2C",
        paddingVertical: dpr(12),
        textAlign: 'left'
    },
    singleSubLine: {
        borderBottomWidth: 1,
        borderColor: "#DFDFDF",
    },
    dropdownIcon: {
        flexDirection: "row",
        alignItems: "center",
    },
    subCategoryMenu: {
        width: dpr("wf") - dpr(150),
    },
    searchButton: {
        position: "absolute",
        right: dpr(24),
        top: dpr(21),
    }

});

export { allCategoriesStyle };
